-------------------------------------------------------------------------

-- Tallbird
local function AddBirdLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('deerclops_eyeball',0.05)
end
-- Beefalo
local function AddBeefaloLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('minotaurhorn',0.05)
end
-- Clockworks
local function AddClockworkLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('trinket_6',0.05)
end
-- Treeguards
local function AddLeifLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('greengem',0.10)
end
-- Depths Worm
local function AddWormLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('purplegem',0.10)
end
-- Bosses (Tier 1)
local function AddBoss1Loot(prefab)
	prefab.components.lootdropper:AddChanceLoot('thulecite',1)
	prefab.components.lootdropper:AddChanceLoot('thulecite',0.5)
end
-- Bosses (Tier 2)
local function AddBoss2Loot(prefab)
	prefab.components.lootdropper:AddChanceLoot('thulecite',1)
	prefab.components.lootdropper:AddChanceLoot('thulecite',1)
	prefab.components.lootdropper:AddChanceLoot('thulecite',1)
end
-- Shadow Creatures
local function AddShadow1Loot(prefab)
	prefab.components.lootdropper:AddChanceLoot('nightsword',0.07)
	prefab.components.lootdropper:AddChanceLoot('armor_sanity',0.07)
end
-- Ruins Shadow Creatures
local function AddShadow2Loot(prefab)
	prefab.components.lootdropper:AddChanceLoot('nightsword',0.10)
	prefab.components.lootdropper:AddChanceLoot('armor_sanity',0.10)
end
-- Rock Lobster
local function AddRockyLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('redgem',0.10)
	prefab.components.lootdropper:AddChanceLoot('bluegem',0.10)
	prefab.components.lootdropper:AddChanceLoot('purplegem',0.07)
	prefab.components.lootdropper:AddChanceLoot('orangegem',0.05)
	prefab.components.lootdropper:AddChanceLoot('yellowgem',0.05)
	prefab.components.lootdropper:AddChanceLoot('greengem',0.05)
end
-- Rabbit
local function AddRabbitLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('manrabbit_tail',0.05)
	prefab.components.lootdropper:AddChanceLoot('carrot',0.05)
end
-- Hounds
local function AddHoundLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('beardhair',0.05)
end
-- Pigs
local function AddPigLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('meat_dried',0.05)
	prefab.components.lootdropper:AddChanceLoot('goldnugget',0.05)
	prefab.components.lootdropper:AddChanceLoot('walrus_tusk',0.03)
end
-- Butterfly
local function AddButterflyLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('butter',0.10)
end
-- Krampus
local function AddKrampusLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('krampus_sack',0.10)
end
-- Spiders
local function AddSpiderLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('spidereggsack',0.05)
end
-- Bees
local function AddBeeLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('beehat',0.05)
	prefab.components.lootdropper:AddChanceLoot('bugnet',0.05)
end
-- Birds
local function AddBird2Loot(prefab)
	prefab.components.lootdropper:AddChanceLoot('boomerang',0.03)
end
-- Mosquito
local function AddMosqLoot(prefab)
	prefab.components.lootdropper:AddChanceLoot('beemine',0.05)
end
-------------------------------------------------------------------------

-- Tallbird
AddPrefabPostInit("tallbird", AddBirdLoot)
-- Beefalo
AddPrefabPostInit("beefalo", AddBeefaloLoot)
-- Clockworks
AddPrefabPostInit("knight", AddClockworkLoot)
AddPrefabPostInit("knight_nightmare", AddClockworkLoot)
AddPrefabPostInit("bishop", AddClockworkLoot)
AddPrefabPostInit("bishop_nightmare", AddClockworkLoot)
AddPrefabPostInit("rook", AddClockworkLoot)
AddPrefabPostInit("rook_nightmare", AddClockworkLoot)
-- Treeguards
AddPrefabPostInit("leif", AddLeifLoot)
AddPrefabPostInit("leif_sparse", AddLeifLoot)
-- Dephts Worm
AddPrefabPostInit("worm", AddWormLoot)
-- Bosses (Tier 1)
AddPrefabPostInit("leif", AddBoss1Loot)
AddPrefabPostInit("leif_sparse", AddBoss1Loot)
AddPrefabPostInit("spiderqueen", AddBoss1Loot)
-- Bosses (Tier 2)
AddPrefabPostInit("deerclops", AddBoss2Loot)
AddPrefabPostInit("minotaur", AddBoss2Loot)
-- Shadow Creatures
AddPrefabPostInit("crawlinghorror", AddShadow1Loot)
AddPrefabPostInit("terrorbeak", AddShadow1Loot)
-- Ruins Shadow Creatures
AddPrefabPostInit("crawlingnightmare", AddShadow2Loot)
AddPrefabPostInit("nightmarebeak", AddShadow2Loot)
-- Rock Lobster
AddPrefabPostInit("rocky", AddRockyLoot)
-- Rabbit
AddPrefabPostInit("rabbit", AddRabbitLoot)
-- Hounds
AddPrefabPostInit("hound", AddHoundLoot)
AddPrefabPostInit("firehound", AddHoundLoot)
AddPrefabPostInit("icehound", AddHoundLoot)
-- Pigs
AddPrefabPostInit("pigman", AddPigLoot)
AddPrefabPostInit("pigguard", AddPigLoot)
-- Butterfly
AddPrefabPostInit("butterfly", AddButterflyLoot)
-- Krampus
AddPrefabPostInit("krampus", AddKrampusLoot)
-- Spiders
AddPrefabPostInit("spider", AddSpiderLoot)
AddPrefabPostInit("spider_warrior", AddSpiderLoot)
-- Bees
AddPrefabPostInit("bee", AddBeeLoot)
AddPrefabPostInit("killerbee", AddBeeLoot)
-- Birds
AddPrefabPostInit("crow", AddBird2Loot)
AddPrefabPostInit("robin", AddBird2Loot)
AddPrefabPostInit("robin_winter", AddBird2Loot)
-- Mosquito
AddPrefabPostInit("mosquito", AddMosqLoot)
-------------------------------------------------------------------------